/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class DataRepProcess
implements Runnable {
    private static final String TRACE_MASKT = "XSRDDRAT";
    private static final String TRACE_MASKF = "XSRDDRAF";
    private static final String TRACE_MASKD = "XSRDDRAD";
    private FcsConnection connected;
    private TreeMap treeData;

    DataRepProcess(FcsConnection connection, TreeMap customData) {
        this.connected = connection;
        this.treeData = customData;
    }

    public void run() {
        DataRepApp dataRepApp = DataRepApp.getDataRepApp();
        FcsServer server = FcsServer.getFcsServer();
        MachineId myMachine = server.getLocalMachineId();
        Object[] myObjOut = new Object[]{new String("You Rang"), myMachine};
        String inString = "";
        try {
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(this.connected.getSocket().getOutputStream()));
            out.writeObject(myObjOut);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(this.connected.getSocket().getInputStream()));
            MachineId machId = null;
            block3: while (!inString.equals("Exit")) {
                int i;
                String hmcName;
                inString = (String)in.readObject();
                Trace.trace(TRACE_MASKT, "<-DataRepProcess.run() received:" + inString);
                if (inString.equals("Register Me")) {
                    machId = (MachineId)in.readObject();
                    if (dataRepApp.isDataRepEnabled()) {
                        hmcName = machId.getName();
                        InetAddress[] inetAddress = machId.getNicAddresses();
                        String[] ipAddrArray = new String[inetAddress.length];
                        int i2 = 0;
                        while (i2 < inetAddress.length) {
                            ipAddrArray[i2] = inetAddress[i2].getHostAddress();
                            ++i2;
                        }
                        dataRepApp.removeDeniedSlave(hmcName);
                        dataRepApp.addRegisteredSlave(hmcName, ipAddrArray);
                        Object[][] mylevels = new Object[this.treeData.size()][2];
                        Set keys = this.treeData.keySet();
                        i = 0;
                        Iterator it = keys.iterator();
                        while (it.hasNext()) {
                            String dataKey = (String)it.next();
                            Object[] objArray = (Object[])this.treeData.get(dataKey);
                            mylevels[i][0] = dataKey;
                            mylevels[i][1] = objArray[0];
                            ++i;
                        }
                        out.writeObject("Registered");
                        out.writeObject(mylevels);
                        out.flush();
                        continue;
                    }
                    out.writeObject("Disabled");
                    out.flush();
                    if (dataRepApp.isSlaveDenied(machId.getName())) continue;
                    String[] substData = new String[]{machId.getName(), this.connected.getSocket().getInetAddress().getHostAddress()};
                    FrameworkEventText fet = new FrameworkEventText(883, substData);
                    new SystemEventLog(fet, "CustDataLan").log();
                    dataRepApp.addDeniedSlave(machId.getName());
                    continue;
                }
                if (inString.equals("Get Object")) {
                    String customKey = (String)in.readObject();
                    if (dataRepApp.isDataRepEnabled()) {
                        Object[] obj = (Object[])this.treeData.get(customKey);
                        if (obj != null) {
                            out.writeObject("Obj Found");
                            out.writeObject(obj[3]);
                            out.writeObject(obj[0]);
                            out.flush();
                            String[] substData = new String[]{machId.getName(), this.connected.getSocket().getInetAddress().getHostAddress(), dataRepApp.getCustomDataName(customKey), ((Long)obj[0]).toString()};
                            FrameworkEventText fet = new FrameworkEventText(885, substData);
                            new SystemEventLog(fet, "CustDataLan").log();
                            continue;
                        }
                        out.writeObject("Obj Not Found");
                        out.flush();
                        continue;
                    }
                    out.writeObject("Disabled");
                    out.flush();
                    continue;
                }
                if (inString.equals("UnRegister Me")) {
                    machId = (MachineId)in.readObject();
                    hmcName = machId.getName();
                    dataRepApp.removeRegisteredSlave(hmcName);
                    out.writeObject("Id Deleted");
                    out.flush();
                    continue;
                }
                if (!inString.equals("New Levels")) continue;
                machId = (MachineId)in.readObject();
                Object[][] sourceVerLevels = (Object[][])in.readObject();
                if (dataRepApp.isDataRepEnabled()) {
                    String machIdName;
                    TreeMap hmcSources = dataRepApp.getHmcSources();
                    if (hmcSources.containsKey(machIdName = machId.getName())) {
                        Object[] objArray = (Object[])hmcSources.get(machIdName);
                        TreeMap interestedData = new TreeMap();
                        String[] dataSources = (String[])objArray[1];
                        i = 0;
                        while (i < dataSources.length) {
                            interestedData.put(dataSources[i], null);
                            ++i;
                        }
                        int i3 = 0;
                        while (i3 < sourceVerLevels.length) {
                            String customDataKey = (String)sourceVerLevels[i3][0];
                            if (interestedData.containsKey(customDataKey) && (Long)sourceVerLevels[i3][1] > dataRepApp.getCustomDataLevel(customDataKey)) {
                                out.writeObject("Get Object");
                                out.writeObject(customDataKey);
                                out.flush();
                                inString = (String)in.readObject();
                                if (inString.equals("Obj Found")) {
                                    Serializable serObject = (Serializable)in.readObject();
                                    Long serObjectLvl = (Long)in.readObject();
                                    dataRepApp.updateCustomData(customDataKey, serObject, serObjectLvl);
                                    String[] substData = new String[]{machId.getName(), this.connected.getSocket().getInetAddress().getHostAddress(), dataRepApp.getCustomDataName(customDataKey), serObjectLvl.toString()};
                                    FrameworkEventText fet = new FrameworkEventText(886, substData);
                                    new SystemEventLog(fet, "CustDataLan").log();
                                } else if (inString.equals("Disabled")) {
                                    out.writeObject("Exit");
                                    out.flush();
                                    continue block3;
                                }
                            }
                            ++i3;
                        }
                        continue;
                    }
                    out.writeObject("Exit");
                    out.flush();
                    continue;
                }
                out.writeObject("Exit");
                out.flush();
            }
            out.close();
            in.close();
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKT, "<-DataRepApp.process() exception:" + ioe);
        }
        catch (ClassNotFoundException cnfe) {
            Trace.trace(TRACE_MASKT, "<-DataRepApp.process() exception:" + cnfe);
        }
    }
}

